#include "Parametres.h"
#include "Variables.h"
#include "Setup_server.h"

#include "Light_animations.h"
#include "Fonctions.h"
#include "Event_server.h"
#include "Light_modes.h"
#include "Telecommande.h"
#include "Gestes.h"
#include "Timer.h"
#include "Post.h"
#include "Boutons.h"




void setup() {
  if (RGB_RESET_ALL) {

    Serial.begin(115200);
    while (!Serial)
      ;
    delay(500);



    Serveur.Debug(true);
    Serveur.Init();
    Serial.println("");
    Serial.println("RESET_ALL");
    Serveur.ResetAll();
  } else {

    Serial.begin(115200);
    while (!Serial)
      ;
    delay(500);



    pinMode(LED_1, OUTPUT);
    pinMode(LED_2, OUTPUT);
    pinMode(BOUTON_MODE_PALETTE, INPUT);
    pinMode(BOUTON_POWER, INPUT_PULLUP);
    Serveur.ResetButton();

    digitalWrite(LED_1, HIGH);


    Setup_server();


    //RELAIS
    if (RELAIS) pinMode(RELAIS_PIN, OUTPUT);


    //Chargement des Paramètres sauvegardés
    //Etat Lumière
    if (Memoire_Lumiere != "Off") {
      RAM_Lumiere_Actuelle = Memoire_Lumiere;
      Memoire_Lumiere = "Off";
    }else{
      RAM_Lumiere_Actuelle = Favoris;
    }






    //Micro
    if (MICRO) {
      pinMode(MICRO_PIN, INPUT);
      //Vumetre
      if (Memoire_Vumetre == 0) {
        Vumetre = false;
        Memoire_Vumetre = 0;
        Serveur.IndexSetToogle(Bouton_Vumetre_Off);
      } else {
        Vumetre = true;
        Memoire_Vumetre = 1;
        Serveur.IndexSetToogle(Bouton_Vumetre_On);
      }
    }
    if (Memoire_NB_LEDS > 100) Vu_Supp = true;
    else Vu_Supp = false;

    //Télécommande
    if (TELECOMMANDE) IrReceiver.begin(IR_RECEIVE_PIN);

    //FASTLED
    FastLED.addLeds<LEDS_TYPE, LEDS_PIN, COLOR_ORDER>(LED, MAX_LEDS).setCorrection(TypicalLEDStrip);
    FastLED.clear();
    FastLED.show();
    FastLED.setBrightness(Serveur.IndexGetRange(Range_Luminosite));

    //PAJ
    if (PAJ) {
      while (paj.begin() != 0) {
        if (RGB_DEBUG) Serial.print(".");
        delay(100);
        Test_PAJ++;
        if (Test_PAJ == 10) {
          Clignote(10, 100, 255, 0, 0);
          break;
        }
      }

      paj.setGestureHighRate(true);
    }



    //USB
    if (RELAIS) {
      if (Memoire_USB == 0) {
        Relais_Off();
      } else {
        Relais_On();
      }
    }

    if (Serveur.GetWiFiStatus() == 1) {

    } else {
      Clignote_LED(2, 2, 500);
      Clignote(2, 500, 255, 255, 0);
      Clignote(2, 500, 255, 0, 0);
    }

    if (Memoire_Sym == 0) {
      Serveur.IndexSetToogle(Bouton_Sym_Off);
    } else {
      Serveur.IndexSetToogle(Bouton_Sym_On);
    }

    digitalWrite(LED_1, LOW);
  }
}


void loop() {


  if (digitalRead(BOUTON_POWER) == HIGH) {
    if (Serveur.GetWiFiStatus() == 1) {
      digitalWrite(LED_2, LOW);

    } else {
      digitalWrite(LED_2, HIGH);
    }
  }

  Event_server();
  Light_modes();
  if (TELECOMMANDE) {
    if (!SIMPLE) Telecommande();
    else Telecommande_SIMPLE();
  }
  if (PAJ) Gestes();
  Timer();
  if (RELAIS) Timer_USB();
  Post();
  Boutons();
}
