
void Init_Palette(bool FEU = false) {
  currentBlending = LINEARBLEND;
  sw = true;
  Global_i = 0;
  Global_j = 1;
  Global_i_fade = 0;
  Fade_bool = true;
  Global_Luminosite = 0;
  Up_Vu_Ring = true;
  Vu_Supp = false;
  Fire_Vumetre = 0;
  Vumetre_Value = 0;
  peak = 0;
  pi = 0;
  Conf = 0;
  startIndex = 0;
  startIndex1 = 0;
  if (!FEU) {
    if (Memoire_Lumiere == "Rainbow") {
      currentPalette = RainbowColors_p;
    } else if (Memoire_Lumiere == "Rainbow stripe") {
      currentPalette = RainbowStripeColors_p;
    } else if (Memoire_Lumiere == "Nuages") {
      currentPalette = CloudColors_p;
    } else if (Memoire_Lumiere == "Océan") {
      currentPalette = OceanColors_p;
    } else if (Memoire_Lumiere == "Forêt") {
      currentPalette = ForestColors_p;
    } else if (Memoire_Lumiere == "Lave") {
      currentPalette = LavaColors_p;
    } else if (Memoire_Lumiere == "Fête") {
      currentPalette = PartyColors_p;
    } else if (Memoire_Lumiere == "Coeur") {
      currentPalette = HeatColors_p;
    } else if (Memoire_Lumiere == "eeBud") {
      currentPalette = PaletteDeeeBud;
    } else if (Memoire_Lumiere == "Random") {
      Palette_Aleatoire();
    } else if (Memoire_Lumiere == "Blanc chaud") {
      Palette_RGB_Double(255, 95, 10, 255, 95, 10);
    } else if (Memoire_Lumiere == "Blanc froid") {
      Palette_RGB_Double(172, 201, 255, 172, 201, 255);
    } else if (Memoire_Lumiere == "Confétis") {
      Palette_Aleatoire();
    } else if (Memoire_Lumiere == "Perso") {
      Palette_RGB_Triple(Memoire_R1, Memoire_G1, Memoire_B1, Memoire_R2, Memoire_G2, Memoire_B2, Memoire_R3, Memoire_G3, Memoire_B3);
    }
  } else {
    if (Memoire_Lumiere == "Rainbow") {
      currentPalette = Palette_Feu_Rainbow;
    } else if (Memoire_Lumiere == "Rainbow stripe") {
      currentPalette = Palette_Feu_Rainbow_Stripe;
    } else if (Memoire_Lumiere == "Nuages") {
      currentPalette = Palette_Feu_Nuages;
    } else if (Memoire_Lumiere == "Océan") {
      currentPalette = Palette_Feu_Ocean;
    } else if (Memoire_Lumiere == "Forêt") {
      currentPalette = Palette_Feu_Foret;
    } else if (Memoire_Lumiere == "Lave") {
      currentPalette = LavaColors_p;
    } else if (Memoire_Lumiere == "Fête") {
      currentPalette = Palette_Feu_Fete;
    } else if (Memoire_Lumiere == "Coeur") {
      currentPalette = HeatColors_p;
    } else if (Memoire_Lumiere == "eeBud") {
      currentPalette = Palette_Feu_eeBud;
    } else if (Memoire_Lumiere == "Random") {
      Palette_Aleatoire_Feu();
    } else if (Memoire_Lumiere == "Blanc chaud") {
      Palette_Feu_RGB_Simple(255, 95, 10);
    } else if (Memoire_Lumiere == "Blanc froid") {
      Palette_Feu_RGB_Simple(172, 201, 255);
    } else if (Memoire_Lumiere == "Confétis") {
      Palette_Aleatoire();
    } else if (Memoire_Lumiere == "Perso") {
      Palette_RGB_Triple(Memoire_R1, Memoire_G1, Memoire_B1, Memoire_R2, Memoire_G2, Memoire_B2, Memoire_R3, Memoire_G3, Memoire_B3);
    }
  }
}

void Init_Palette_Perm(bool FEU = false) {
  currentBlending = LINEARBLEND;
  if (!FEU) {
    if (Memoire_Lumiere == "Confétis") {
      Palette_Aleatoire();
    } else if (Memoire_Lumiere == "Perso") {
      Palette_RGB_Triple(Memoire_R1, Memoire_G1, Memoire_B1, Memoire_R2, Memoire_G2, Memoire_B2, Memoire_R3, Memoire_G3, Memoire_B3);
    }
  } else {
    if (Memoire_Lumiere == "Confétis") {
      Palette_Aleatoire_Feu();
    } else if (Memoire_Lumiere == "Perso") {
      Palette_Feu_RGB_Perso();
    }
  }
}

void Eteindre_All() {
  FastLED.clear();
  FastLED.clearData();
  FastLED.show();
}

void Clignote(int Nombre, int Intervalle, int R, int G, int B) {
  for (int j = 1; j <= Nombre; j++) {
    for (int i = 0; i <= Memoire_NB_LEDS; i++) {
      LED[i].setRGB(R, G, B);
    }
    FastLED.show();
    delay(Intervalle);
    for (int i = 0; i <= Memoire_NB_LEDS; i++) {
      LED[i].setRGB(0, 0, 0);
    }
    FastLED.show();
    if (j != Nombre) delay(Intervalle);
  }
}



void Eteindre1() {

  int intervalle = Memoire_NB_LEDS / Memoire_Portions;

  if (!Vu_Supp) {
    /*if (Memoire_Portions % 2 == 0) {  // Si nombre pair
      for (int i = 0; i <= intervalle; i++) {
        for (int j = 1; j <= Memoire_Portions; j++) {

          int Allumage = (intervalle * j);
          if (Allumage - i >= 0) {
            LED[Allumage - i].setRGB(0, 0, 0);
          }
          if (Memoire_NB_LEDS - (Allumage - i) < Memoire_NB_LEDS) {
            LED[Memoire_NB_LEDS - (Allumage - i)].setRGB(0, 0, 0);
          }
        }
        FastLED.show();
        FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
      }
    } else {*/
    for (int i = 0; i <= intervalle; i++) {
      for (int j = 1; j <= Memoire_Portions; j++) {
        int Allumage = intervalle * j;
        if (Allumage - i >= 0) {
          LED[Allumage - i].setRGB(0, 0, 0);
        }
      }
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
    }
    // }
  } else {
    /*if (Memoire_Portions % 2 == 0) {
      for (int i = 0; i <= intervalle+3; i = i + 3) {
        for (int j = 1; j <= Memoire_Portions / 2; j++) {
          for (int k = 0; k < 3; k++) {
            int Allumage = intervalle * j;
            if (Allumage - i - k >= 0) {
              LED[Allumage - i - k].setRGB(0, 0, 0);
            }
            if (Memoire_NB_LEDS - (Allumage - i) - k < Memoire_NB_LEDS) {
              LED[Memoire_NB_LEDS - (Allumage - i) - k].setRGB(0, 0, 0);
            }
          }
          FastLED.show();
        }
      }
    } else {*/
    for (int i = 0; i <= intervalle; i = i + 3) {
      for (int j = 1; j <= Memoire_Portions; j++) {
        for (int k = 0; k < 3; k++) {
          int Allumage = intervalle * j;
          if (Allumage - i - k >= 0) {
            LED[Allumage - i - k].setRGB(0, 0, 0);
          }
        }
        FastLED.show();
      }
    }
    //}
  }
  LED[0].setRGB(0, 0, 0);
  LED[Memoire_NB_LEDS - 1].setRGB(0, 0, 0);
  FastLED.show();
  FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
}

void Couleur_Simple_RGB_All(int r, int g, int b) {

  for (int i = 0; i <= Memoire_NB_LEDS; i++) {
    LED[i].setRGB(r, g, b);
  }
  FastLED.show();
}

void FillLEDsFromPaletteColors(uint8_t colorIndex, int Lum = Memoire_Luminosite) {
  if (Memoire_Sym == 0) {
    for (int i = 0; i < Memoire_NB_LEDS; ++i) {
      LED[i] = ColorFromPalette(currentPalette, colorIndex, Lum, currentBlending);
      colorIndex += 3;
    }

  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    for (int i = 0; i < Div; ++i) {
      LED[i] = ColorFromPalette(currentPalette, colorIndex, Lum, currentBlending);
      LED[Memoire_NB_LEDS - i - 1] = ColorFromPalette(currentPalette, colorIndex, Lum, currentBlending);
      colorIndex += 3;
    }
  }
}

void FillLEDsFromPaletteColors_Variable(uint8_t colorIndex, int Lumin) {
  if (Lumin < 0) Lumin = 0;
  else if (Lumin > Memoire_Luminosite) Lumin = Memoire_Luminosite;

  if (Memoire_Sym == 0) {
    for (int i = 0; i < Memoire_NB_LEDS; ++i) {
      LED[i] = ColorFromPalette(currentPalette, colorIndex, Lumin, currentBlending);
      colorIndex += 3;
    }

  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    for (int i = 0; i < Div; ++i) {
      LED[i] = ColorFromPalette(currentPalette, colorIndex, Lumin, currentBlending);
      LED[Memoire_NB_LEDS - i - 1] = ColorFromPalette(currentPalette, colorIndex, Lumin, currentBlending);
      colorIndex += 3;
    }
  }
}

void FillLEDsFromPaletteColors_Ring(uint8_t colorIndex) {
  if (Memoire_Sym == 0) {
    LED[Memoire_NB_LEDS - pi - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    colorIndex += 3;
    pi++;
    FastLED.show();
    nscale8_video(LED, Memoire_NB_LEDS, 250);
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_RING));
    if (pi >= Memoire_NB_LEDS + 1) {
      pi = 0;
    }


  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    LED[Memoire_NB_LEDS - pi - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);

    colorIndex += 3;
    pi++;
    FastLED.show();
    nscale8_video(LED, Memoire_NB_LEDS, 250);
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_RING));
    if (pi >= Div) {
      pi = 0;
    }
  }
}

void FillLEDsFromPaletteColors_Ring_Up(uint8_t colorIndex, int Nombre = Memoire_NB_LEDS) {
  if (Memoire_Sym == 0) {
    for (pi = 0; pi < Nombre; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      colorIndex += 1;
      nscale8_video(LED, Nombre, 250);
      if (!Vu_Supp) fadeToBlackBy(LED, Memoire_NB_LEDS, 10);
    }

  } else {
    for (pi = 0; pi < Nombre; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      LED[Memoire_NB_LEDS - pi - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      colorIndex += 1;
      nscale8_video(LED, Memoire_NB_LEDS, 250);
      if (!Vu_Supp) fadeToBlackBy(LED, Memoire_NB_LEDS, 10);
    }
  }
  Up_Vu_Ring = false;
}

void FillLEDsFromPaletteColors_Ring_Down(uint8_t colorIndex, int Nombre = Memoire_NB_LEDS, int Coeff_Ring = 1) {
  if (Memoire_Sym == 0) {
    for (pi = 0; pi < Nombre; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      nscale8(LED, Nombre, 250);
      colorIndex += 3;
      if (!Vu_Supp) fadeToBlackBy(LED, Memoire_NB_LEDS, 10);
    }
    for (int i = 3; i > 0; i--) {
      if (pi - 1 + i >= 0) {
        LED[pi - 1].setRGB(Memoire_R1, Memoire_G1, Memoire_B1);
        blur1d(LED, Nombre, 172);
      }
    }
    for (int i = 3; i >= 0; i--) {
      if (pi + i < Memoire_NB_LEDS) {
        LED[pi + i].setRGB(0, 0, 0);
      }
    }
  } else {
    for (pi = 0; pi < Nombre; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      LED[Memoire_NB_LEDS - pi - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      nscale8(LED, Memoire_NB_LEDS, 250);
      colorIndex += 3;
      if (!Vu_Supp) fadeToBlackBy(LED, Memoire_NB_LEDS, 10);
    }
    for (int i = 3; i > 0; i--) {
      if (pi - 1 + i >= 0) {
        LED[pi - 1].setRGB(Memoire_R1, Memoire_G1, Memoire_B1);
        LED[Memoire_NB_LEDS - pi - 1].setRGB(Memoire_R1, Memoire_G1, Memoire_B1);
        blur1d(LED, Memoire_NB_LEDS, 172);
      }
    }
    for (int i = 3; i >= 0; i--) {
      if (pi + i < Memoire_NB_LEDS) {
        LED[pi + i].setRGB(0, 0, 0);
        LED[Memoire_NB_LEDS - pi - 1 - i].setRGB(0, 0, 0);
      }
    }
  }
  pi--;
  FastLED.show();
  FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_RING * Coeff_Ring));
  if (pi <= 0) {
    pi = 0;
    Up_Vu_Ring = true;
  }
}

void Palette_Symetrique(uint8_t colorIndex) {

  for (int i = 0; i <= Memoire_NB_LEDS / 2; ++i) {
    LED[Memoire_NB_LEDS / 2 - i] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    LED[Memoire_NB_LEDS / 2 + i] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    colorIndex += 3;
  }
}

void FillLEDsFromPaletteColors_Nb(uint8_t colorIndex, int Nb_Leds) {
  if (Memoire_Sym == 0) {
    for (pi = 0; pi < Nb_Leds; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      colorIndex += 3;
    }
  } else {
    //Nb_Leds = Nb_Leds / 2;
    for (pi = 0; pi < Nb_Leds; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      LED[Memoire_NB_LEDS - pi - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      colorIndex += 3;
    }
  }
}

void FillLEDsFromPaletteColors_Nb_Respiration(uint8_t colorIndex, int Nb_Leds) {
  if (Memoire_Sym == 0) {
    for (pi = 0; pi < Nb_Leds; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      colorIndex += 3;
    }
  } else {
    //Nb_Leds = Nb_Leds / 2;
    for (pi = 0; pi < Nb_Leds; pi++) {
      LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      LED[Memoire_NB_LEDS - pi - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
      colorIndex += 3;
    }
  }
}

void FillLEDsFromPaletteColors_Nb_Alarme(uint8_t colorIndex, int Nb_Leds) {

  int intervalle = (Memoire_NB_LEDS / Memoire_Portions);
  for (pi = 1; pi <= Memoire_Portions; pi++) {
    int Allumage = (intervalle * pi) - (intervalle / 2);
    LED[Allumage - pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    LED[Allumage + pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
  }
}

void FillLEDsFromPaletteColors_Nb_Swipe(uint8_t colorIndex, int Nb_Leds) {

  for (pi = 0; pi < Nb_Leds; pi++) {
    LED[Memoire_NB_LEDS / 2 - pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    LED[Memoire_NB_LEDS / 2 + pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    colorIndex += 3;
  }
}

void FillLEDsFromPaletteColors_Num(uint8_t colorIndex, int Num_Led) {

  if (Memoire_Sym == 0) {
    LED[Num_Led] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
  } else {
    LED[Num_Led] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    LED[Memoire_NB_LEDS - Num_Led - 1] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
  }
}


void Allumage() {

  startIndex = 0;



  

  if (Memoire_Sym == 0) {
    int Vit =(Memoire_NB_LEDS / 100) + 4;
    int Div = Memoire_NB_LEDS;
    for (int i = 0; i < Div; i = i + Vit) {
      //startIndex = startIndex + 3;
      for (int j = 0; j < Vit; j++) {

        if (i + j >= 0 && i + j < Div) FillLEDsFromPaletteColors_Num(startIndex, i + j);
        startIndex = startIndex + 3;
      }
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
    }

  } else {
    int Vit =(Memoire_NB_LEDS / 100) + 2;
    int Div = Memoire_NB_LEDS / 2+1;
    for (int i = 0; i < Div; i = i + Vit) {
      //startIndex = startIndex + 3;
      for (int j = 0; j < Vit; j++) {

        if (i - j >= 0) FillLEDsFromPaletteColors_Num(startIndex, i + j);
        if (Memoire_NB_LEDS - i - 1 - j < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - i - 1 - j);
        startIndex = startIndex + 3;
      }
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
    }
  }

  startIndex = 0;
}

void Eteindre() {

  
  if (Memoire_Sym == 0) {
    int Vit = (Memoire_NB_LEDS / 100) + 4;
    int Div = Memoire_NB_LEDS ;
    for (int i = 0; i < Div; i = i + Vit) {
      //startIndex = startIndex + 3;
      for (int j = 0; j < Vit; j++) {

        if (i + j >= 0 && i + j < Div) LED[i + j].setRGB(0, 0, 0);
      }
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
    }
    FastLED.clear();
    FastLED.show();

  } else {
    int Vit = (Memoire_NB_LEDS / 100) + 2;
    int Div = Memoire_NB_LEDS / 2 +1;
    for (int i = 0; i < Div; i = i + Vit) {
      //startIndex = startIndex + 3;
      for (int j = 0; j < Vit; j++) {

        if (i + j >= 0) LED[i + j].setRGB(0, 0, 0);
        if (Memoire_NB_LEDS - i - 1 - j < Memoire_NB_LEDS) LED[Memoire_NB_LEDS - i - 1 - j].setRGB(0, 0, 0);
        startIndex = startIndex + 3;
      }
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
    }
    FastLED.clear();
    FastLED.show();
  }
}

void Allumage1() {

  pi = 0;



  if (Memoire_Sym == 0) {
    int intervalle = Memoire_NB_LEDS / Memoire_Portions;
    startIndex1 = 0;
    startIndex = 0;

    Global_i = Memoire_Luminosite;
    sw = false;

    if (!Vu_Supp) {

      for (int i = 0; i <= intervalle; i++) {
        startIndex = startIndex + 3;
        for (int j = 1; j <= Memoire_Portions; j++) {

          int Allumage = intervalle * j;
          startIndex1 = (Allumage * 3 - i * 3);
          FillLEDsFromPaletteColors_Num(startIndex1, Allumage - i);
        }
        FastLED.show();
        FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
      }

    } else {

      for (int i = 0; i <= intervalle; i = i + 3) {
        startIndex = startIndex + 3;
        for (int j = 1; j <= Memoire_Portions; j++) {
          for (int k = 0; k < 3; k++) {
            int Allumage = intervalle * j;
            startIndex1 = (Allumage * 3 - i * 3) - (k * 3);
            if (Allumage - i - k >= 0) {
              FillLEDsFromPaletteColors_Num(startIndex1, Allumage - i - k);
            }
          }
        }
        FastLED.show();
      }
    }
    startIndex1 = 0;
    startIndex = 0;



  } else {

    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;



    if (!Vu_Supp) {
      for (int i = 0; i < Div; i++) {

        FillLEDsFromPaletteColors_Num(startIndex, i);
        FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - i - 1);
        FastLED.show();
        startIndex = startIndex + 3;
      }

    } else {
      for (int i = 0; i < Div; i = i + 3) {
        //startIndex = startIndex + 3;
        for (int j = 0; j < 3; j++) {

          if (i - j > 0) FillLEDsFromPaletteColors_Num(startIndex, i - j);
          if (Memoire_NB_LEDS - i - 1 + j < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - i - 1 + j);
          startIndex = startIndex + 3;
        }


        FastLED.show();
        FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALLUMAGE);
      }
    }
    startIndex = 0;
  }
}
void Palette_Alarme() {

  if (!DoOne) {
    Eteindre();
    Init_Palette();
    Global_i = 0;
    sw = true;
    DoOne = true;
    pi = 1;
  }
  Init_Palette_Perm();

  int intervalle = (Memoire_NB_LEDS / Memoire_Portions);
  static uint8_t startIndex = 0;
  startIndex = startIndex + 1;



  if (sw) {

    int Allumage = (intervalle * pi) - (intervalle / 2);
    LED[Allumage - Global_i] = ColorFromPalette(currentPalette, startIndex, Memoire_Luminosite, currentBlending);
    LED[Allumage + Global_i] = ColorFromPalette(currentPalette, startIndex, Memoire_Luminosite, currentBlending);

    pi++;
    if (pi == Memoire_Portions + 1) {
      pi = 1;
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALARME);
      Global_i++;
      if (Global_i > intervalle / 2) {
        sw = false;
        Global_i = 0;
      }
    }

  } else {

    int Allumage = (intervalle * pi) - (intervalle / 2);
    LED[Allumage - Global_i].setRGB(0, 0, 0);
    LED[Allumage + Global_i].setRGB(0, 0, 0);

    pi++;
    if (pi == Memoire_Portions + 1) {
      pi = 1;
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / COEFF_DELAY_ALARME);

      Global_i++;
      if (Global_i > intervalle / 2) {
        sw = true;
        Global_i = 0;
      }
    }
  }
}


void Confetis() {
  if (!DoOne) {
    Eteindre();
    DoOne = true;
  }

  if (Memoire_Sym == 0) {
    fadeToBlackBy(LED, Memoire_NB_LEDS, 2);
    int pos = random16(Memoire_NB_LEDS);
    LED[pos] += CHSV(Conf++ + random8(64), 200, 255);
  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    fadeToBlackBy(LED, Memoire_NB_LEDS, 2);

    int pos = random16(Div);
    int Rand = random8(64);
    LED[pos] += CHSV(Conf++ + Rand, 200, 255);
    LED[Memoire_NB_LEDS - pos - 1] += CHSV(Conf++ + Rand, 200, 255);
  }

  FastLED.delay(Memoire_Vitesse / random(1, COEFF_DELAY_CONFETIS));
  FastLED.show();
}


void Swipe_Rainbow() {

  if (!DoOne) {
    Eteindre();
    Global_i_fade = 0;
    Fade_bool = true;
    DoOne = true;
  }

  static uint8_t hue = 0;

  if (Memoire_Sym == 0) {

    LED[Global_i_fade] = CHSV(hue++, 255, 255);
    FastLED.show();
    nscale8(LED, Memoire_NB_LEDS, 250);
    FastLED.delay(Memoire_Vitesse / COEFF_DELAY_SWIPE);

    if (Fade_bool) {
      Global_i_fade++;
      if (Global_i_fade == Memoire_NB_LEDS - 1) {
        Fade_bool = false;
      }
    } else {
      Global_i_fade--;
      if (Global_i_fade == 0) {
        Fade_bool = true;
      }
    }

  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    LED[Global_i_fade] = CHSV(hue++, 255, 255);
    LED[Memoire_NB_LEDS - Global_i_fade - 1] = CHSV(hue++, 255, 255);
    FastLED.show();
    nscale8(LED, Memoire_NB_LEDS, 250);
    FastLED.delay(Memoire_Vitesse / COEFF_DELAY_SWIPE);
    if (Fade_bool) {

      Global_i_fade++;
      if (Global_i_fade == Div) {
        Fade_bool = false;
      }
    } else {
      Global_i_fade--;
      if (Global_i_fade == 0) {
        Fade_bool = true;
      }
    }
  }
}







void Swipe_Palette() {

  if (!DoOne) {
    Eteindre();
    Init_Palette();
    Global_i_fade = 0;
    Fade_bool = true;
    DoOne = true;
  }
  Init_Palette_Perm();



  static uint8_t hue = 0;

  if (Memoire_Sym == 0) {
    LED[Global_i_fade] = ColorFromPalette(currentPalette, hue++);
    FastLED.show();
    nscale8(LED, Memoire_NB_LEDS, 250);
    FastLED.delay(Memoire_Vitesse / COEFF_DELAY_SWIPE);
    if (Fade_bool) {
      Global_i_fade++;
      if (Global_i_fade == Memoire_NB_LEDS) {
        Fade_bool = false;
      }
    } else {
      Global_i_fade--;
      if (Global_i_fade == 0) {
        Fade_bool = true;
      }
    }

  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    LED[Global_i_fade] = ColorFromPalette(currentPalette, hue++);
    LED[Memoire_NB_LEDS - Global_i_fade - 1] = ColorFromPalette(currentPalette, hue++);
    FastLED.show();
    nscale8(LED, Memoire_NB_LEDS, 250);
    FastLED.delay(Memoire_Vitesse / COEFF_DELAY_SWIPE);
    if (Fade_bool) {
      Global_i_fade++;
      if (Global_i_fade == Div) {
        Fade_bool = false;
      }
    } else {
      Global_i_fade--;
      if (Global_i_fade == 0) {
        Fade_bool = true;
      }
    }
  }
}





void Feu_1() {
  static uint8_t heat[MAX_LEDS];
  if (!DoOne) {
    Eteindre();

    Init_Palette(true);
    Global_Luminosite = 0;
    DoOne = true;
    for (int i = 0; i < Memoire_NB_LEDS; i++) {
      heat[i] = 0;
    }
  }
  Init_Palette_Perm(true);

  random16_add_entropy(random());


  for (int i = 0; i < Memoire_NB_LEDS; i++) {
    heat[i] = qsub8(heat[i], random8(0, ((Memoire_Souffle_1 * 10) / Memoire_NB_LEDS) + 2));
  }

  for (int k = Memoire_NB_LEDS - 1; k >= 2; k--) {
    heat[k] = (heat[k - 1] + heat[k - 2] + heat[k - 2]) / 3;
  }

  if (random8() < Memoire_Etincelles_1) {
    int y = random8(7);
    heat[y] = qadd8(heat[y], random8(160, 255));
  }

  if (Global_Luminosite < Memoire_Luminosite) {

    Global_Luminosite = Global_Luminosite + 1;
    if (Global_Luminosite >= Memoire_Luminosite) Global_Luminosite = Memoire_Luminosite;
  }

  for (int j = 0; j < Memoire_NB_LEDS; j++) {
    uint8_t colorindex = scale8(heat[j], 240);



    int Lum = Global_Luminosite;
    CRGB color = ColorFromPalette(currentPalette, colorindex, Lum, currentBlending);
    int pixelnumber;
    if (gReverseDirection) {
      pixelnumber = (Memoire_NB_LEDS - 1) - j;
    } else {
      pixelnumber = j;
    }
    LED[pixelnumber] = color;
  }
  blur1d(LED, Memoire_NB_LEDS, 70);
  FastLED.show();
  FastLED.delay(Memoire_Vitesse / COEFF_DELAY_FEU);
}

void Feu_2() {
  static uint8_t heat[MAX_LEDS];
  if (!DoOne) {
    Eteindre();

    Init_Palette(true);
    Global_Luminosite = 0;
    DoOne = true;
    for (int i = 0; i < Memoire_NB_LEDS; i++) {
      heat[i] = 0;
    }
  }
  Init_Palette_Perm(true);


  random16_add_entropy(random());


  for (int i = 0; i <= Memoire_NB_LEDS / 2; i++) {
    heat[i] = qsub8(heat[i], random8(0, ((Memoire_Souffle_2 * 20) / Memoire_NB_LEDS) + 2));
    heat[(Memoire_NB_LEDS - i) - 1] = qsub8(heat[i], random8(0, ((Memoire_Souffle_2 * 20) / Memoire_NB_LEDS) + 2));
  }

  for (int k = (Memoire_NB_LEDS / 2) - 2; k >= 2; k--) {
    heat[k] = (heat[k - 1] + heat[k - 2] + heat[k - 2]) / 3;
    heat[Memoire_NB_LEDS + k] = (heat[Memoire_NB_LEDS + k - 1] + heat[Memoire_NB_LEDS + k - 2] + heat[Memoire_NB_LEDS + k - 2]) / 3;
  }

  if (random8() < Memoire_Etincelles_2) {
    int y = random8(7);
    heat[y] = qadd8(heat[y], random8(160, 255));
  }

  if (Global_Luminosite < Memoire_Luminosite) {

    Global_Luminosite = Global_Luminosite + 1;
    if (Global_Luminosite >= Memoire_Luminosite) Global_Luminosite = Memoire_Luminosite;
  }

  for (int j = 0; j < Memoire_NB_LEDS / 2 - 1; j++) {
    uint8_t colorindex = scale8(heat[j], 240);



    int Lum = Global_Luminosite;
    CRGB color = ColorFromPalette(currentPalette, colorindex, Lum, currentBlending);

    int pixelnumber;
    if (gReverseDirection) {
      pixelnumber = (Memoire_NB_LEDS / 2 - 1) - j;
    } else {
      pixelnumber = j;
    }
    LED[pixelnumber] = color;
    if (gReverseDirection) {
      pixelnumber = (Memoire_NB_LEDS / 2 - 1) + j;
    } else {
      pixelnumber = Memoire_NB_LEDS - j - 1;
    }
    LED[pixelnumber] = color;
  }
  blur1d(LED, Memoire_NB_LEDS, 70);
  FastLED.show();
  FastLED.delay(Memoire_Vitesse / COEFF_DELAY_FEU);
}



//PALETTES
void Palettes() {


  if (!DoOne) {
    pi = 0;
    Eteindre();
    Init_Palette();

    startIndex = 0;
    Allumage();
    DoOne = true;
    Global_i = Memoire_Luminosite + 50;
    sw = false;
  }
  Init_Palette_Perm();

  if (Memoire_Lumiere == "Perso") blur1d(LED, Memoire_NB_LEDS, 172);

  if (Memoire_Mode == "Normal") {
    startIndex = startIndex + 1;
    FillLEDsFromPaletteColors(startIndex, Memoire_Luminosite);
    FastLED.show();
    FastLED.delay(Memoire_Vitesse / COEFF_DELAY_NORMAL);

  } else if (Memoire_Mode == "Ring") {

    FillLEDsFromPaletteColors_Ring(startIndex);
    startIndex = startIndex + 1;
  } else if (Memoire_Mode == "Respiration") {

    if (sw) {

      Global_i = Global_i + 2;

      if (Global_i >= Memoire_Luminosite + 50) sw = false;
    } else {

      Global_i = Global_i - 2;
      if (Global_i <= -90) sw = true;
    }

    startIndex = startIndex + 1;
    FillLEDsFromPaletteColors_Variable(startIndex, Global_i);
    FastLED.show();

    FastLED.delay(Memoire_Vitesse / COEFF_DELAY_NORMAL);
  }
}

void Palettes_Stroboscope() {





  if (!DoOne) {

    Eteindre();
    Init_Palette();

    DoOne = true;
  }

  Init_Palette_Perm();

  startIndex = startIndex + 1;
  FillLEDsFromPaletteColors(startIndex, Memoire_Luminosite);
  FastLED.show();
  FastLED.delay(Memoire_Vitesse);

  Eteindre_All();
  FastLED.delay(Memoire_Vitesse);
}

void Vumetre_Palettes_Stroboscope() {



  if (!DoOne) {

    Eteindre();
    Init_Palette();
    peak = 0;

    DoOne = true;
  }

  Init_Palette_Perm();



  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage - ((Memoire_NB_LEDS / 50) * (Memoire_NB_LEDS / 50)) / 2;

  Vumetre_Value = Vumetre_Value * (Memoire_Gain * 3);
  if (Vumetre_Value < 0) Vumetre_Value = 0;




  if (Vumetre_Value > peak) {
    peak = Vumetre_Value;
    if (peak > Memoire_NB_LEDS) peak = Memoire_NB_LEDS;

  } else {
    peak = peak - 2;
    if (peak < 0) peak = 0;
    //peak = pi;
    int limite = Memoire_NB_LEDS - (Memoire_NB_LEDS / (((Memoire_NB_LEDS * Memoire_NB_LEDS) / 10000) + 3));
    /*if (Vu_Supp) limite = Memoire_NB_LEDS - (Memoire_NB_LEDS / 7);
    else limite = Memoire_NB_LEDS - (Memoire_NB_LEDS / 3);*/
    if (peak > limite) {
      startIndex = startIndex + 1;
      FillLEDsFromPaletteColors(startIndex, Memoire_Luminosite);
      FastLED.show();
      int Dely = (((Memoire_NB_LEDS - peak) * (Memoire_NB_LEDS - peak)) / 10);  //- (Memoire_NB_LEDS / 4);
      if (Dely < 0) Dely = 0;
      FastLED.delay(Dely);

      Eteindre_All();
      FastLED.delay(Dely);
    }
  }
}


void Palette_Pluie() {





  if (!DoOne) {

    Eteindre();
    Init_Palette();

    DoOne = true;
  }
  Init_Palette_Perm();

  startIndex = startIndex + 1;

  fadeToBlackBy(LED, Memoire_NB_LEDS, 5);

  if (Memoire_Sym == 0) {
    int pos = random8(Memoire_NB_LEDS);
    if (random8() < 80) {
      if (Vu_Supp) {
        if (pos + 1 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, pos + 1);
        if (pos + 2 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, pos + 2);
        if (pos - 1 > 0) FillLEDsFromPaletteColors_Num(startIndex, pos - 1);
        if (pos - 2 > 0) FillLEDsFromPaletteColors_Num(startIndex, pos - 2);
        FillLEDsFromPaletteColors_Num(startIndex, pos);

      } else {
        FillLEDsFromPaletteColors_Num(startIndex, pos);
      }

      //LED[pos] += ColorFromPalette(currentPalette, startIndex);
    }


  } else {
    int Div;
    if (Memoire_NB_LEDS % 2 == 0) Div = Memoire_NB_LEDS / 2;  // Si nombre pair
    else Div = Memoire_NB_LEDS / 2 + 1;

    int pos = random8(Div);
    if (random8() < 80) {
      if (Vu_Supp) {
        if (pos + 1 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, pos + 1);
        if (pos + 2 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, pos + 2);
        if (pos - 1 > 0) FillLEDsFromPaletteColors_Num(startIndex, pos - 1);
        if (pos - 2 > 0) FillLEDsFromPaletteColors_Num(startIndex, pos - 2);
        FillLEDsFromPaletteColors_Num(startIndex, pos);

        if (Memoire_NB_LEDS - pos - 1 + 1 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - pos - 1 + 1);
        if (Memoire_NB_LEDS - pos - 1 + 2 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - pos - 1 + 2);
        if (Memoire_NB_LEDS - pos - 1 - 1 > 0) FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - pos - 1 - 1);
        if (Memoire_NB_LEDS - pos - 1 - 2 > 0) FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - pos - 1 - 2);
        FillLEDsFromPaletteColors_Num(startIndex, Memoire_NB_LEDS - pos - 1);

      } else {
        FillLEDsFromPaletteColors_Num(startIndex, pos);
      }

      //LED[pos] += ColorFromPalette(currentPalette, startIndex);
    }
  }

  fadeToBlackBy(LED, Memoire_NB_LEDS, 1);
  blur1d(LED, Memoire_NB_LEDS, 172);
  //blur1d(LED, Memoire_NB_LEDS, 100);
  FastLED.show();
  FastLED.delay(Memoire_Vitesse / COEFF_DELAY_NORMAL);
}



void Palettes_Fixes() {


  if (!DoOne) {

    Eteindre();
    Init_Palette();
    Init_Palette_Perm();

    Allumage();
    DoOne = true;
  }
}

//Vumetres
void Vumetre_Feu_1() {
  static uint8_t heat[MAX_LEDS];
  if (!DoOne) {
    Eteindre();
    Init_Palette(true);
    DoOne = true;
    for (int i = 0; i < Memoire_NB_LEDS; i++) {
      heat[i] = 0;
    }
  }
  Init_Palette_Perm(true);

  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;

  Vumetre_Value = Vumetre_Value * Memoire_Gain;

  if (Vumetre_Value > 0) {
    Fire_Vumetre = Vumetre_Value;
  } else {
    //Fire_Vumetre = 0;
    Fire_Vumetre = Fire_Vumetre - 2;
    if (Fire_Vumetre <= 0) Fire_Vumetre = 0;
  }




  random16_add_entropy(random());


  for (int i = 0; i < Memoire_NB_LEDS; i++) {
    heat[i] = qsub8(heat[i], random8(0, ((Memoire_Souffle_1 * 1.3 * Fire_Vumetre) / Memoire_NB_LEDS) + 2));
  }

  for (int k = Memoire_NB_LEDS - 1; k >= 2; k--) {
    heat[k] = (heat[k - 1] + heat[k - 2] + heat[k - 2]) / 3;
  }

  if (random8() < Memoire_Etincelles_1) {
    int y = random8(7);
    heat[y] = qadd8(heat[y], random8(160, 255));
  }

  for (int j = 0; j < Memoire_NB_LEDS; j++) {

    uint8_t colorindex = scale8(heat[j], 240);
    CRGB color = ColorFromPalette(currentPalette, colorindex);
    int pixelnumber;
    if (gReverseDirection) {
      pixelnumber = (Memoire_NB_LEDS - 1) - j;
    } else {
      pixelnumber = j;
    }
    LED[pixelnumber] = color;
  }
  blur1d(LED, Memoire_NB_LEDS, 50);
  FastLED.show();  // display this frame
  FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_FEU * 1.2));
}

void Vumetre_Feu_2() {
  static uint8_t heat[MAX_LEDS];
  if (!DoOne) {
    Eteindre();

    Init_Palette(true);


    DoOne = true;
    for (int i = 0; i < Memoire_NB_LEDS; i++) {
      heat[i] = 0;
    }
  }
  Init_Palette_Perm(true);

  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;

  Vumetre_Value = Vumetre_Value * Memoire_Gain;

  if (Vumetre_Value > 0) {
    Fire_Vumetre = Vumetre_Value;
  } else {
    //Fire_Vumetre = 0;
    Fire_Vumetre = Fire_Vumetre - 2;
    if (Fire_Vumetre <= 0) Fire_Vumetre = 0;
  }




  random16_add_entropy(random());


  for (int i = 0; i <= Memoire_NB_LEDS / 2; i++) {
    heat[i] = qsub8(heat[i], random8(0, ((Memoire_Souffle_2 * Fire_Vumetre * 1.5) / Memoire_NB_LEDS) + 2));
    heat[(Memoire_NB_LEDS - i) - 1] = qsub8(heat[i], random8(0, ((Memoire_Souffle_2 * Fire_Vumetre * 1.5) / Memoire_NB_LEDS) + 2));
  }

  for (int k = (Memoire_NB_LEDS / 2) - 2; k >= 2; k--) {
    heat[k] = (heat[k - 1] + heat[k - 2] + heat[k - 2]) / 3;
    heat[Memoire_NB_LEDS + k] = (heat[Memoire_NB_LEDS + k - 1] + heat[Memoire_NB_LEDS + k - 2] + heat[Memoire_NB_LEDS + k - 2]) / 3;
  }

  if (random8() < Memoire_Etincelles_2) {
    int y = random8(7);
    heat[y] = qadd8(heat[y], random8(160, 255));
  }

  for (int j = 0; j < Memoire_NB_LEDS / 2 - 1; j++) {
    uint8_t colorindex = scale8(heat[j], 240);
    CRGB color = ColorFromPalette(currentPalette, colorindex);
    int pixelnumber;
    if (gReverseDirection) {
      pixelnumber = (Memoire_NB_LEDS / 2 - 1) - j;
    } else {
      pixelnumber = j;
    }
    LED[pixelnumber] = color;
    if (gReverseDirection) {
      pixelnumber = (Memoire_NB_LEDS / 2 - 1) + j;
    } else {
      pixelnumber = Memoire_NB_LEDS - j - 1;
    }
    LED[pixelnumber] = color;
  }
  blur1d(LED, Memoire_NB_LEDS, 50);
  FastLED.show();  // display this frame
  FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_FEU * 1.2));
  //}
}








void Vumetre_Confetis() {
  if (!DoOne) {
    Eteindre();
    DoOne = true;
  }

  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;


  if (Vumetre_Value > 0) {



    if (Memoire_Sym == 0) {
      Vumetre_Value = Vumetre_Value * Memoire_Gain;
    } else {
      Vumetre_Value = (Vumetre_Value * Memoire_Gain) / 2;
    }

    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      if (peak > Memoire_NB_LEDS) peak = Memoire_NB_LEDS;
      if (Memoire_Sym == 0) {
        for (pi = 0; pi < peak; pi++) {
          LED[pi].setRGB(random(0, random(0, 255)), random(0, random(0, 255)), random(0, random(0, 255)));
        }
      } else {
        for (pi = 0; pi < peak; pi++) {
          LED[pi].setRGB(random(0, random(0, 255)), random(0, random(0, 255)), random(0, random(0, 255)));
          LED[Memoire_NB_LEDS - pi - 1].setRGB(random(0, random(0, 255)), random(0, random(0, 255)), random(0, random(0, 255)));
        }
      }
      FastLED.show();
    }
  } else {
    pi--;
    if (pi < 0) pi = 0;
    peak = pi;
    if (Memoire_Sym == 0) {
      for (int zi = 0; zi < pi; zi++) {
        LED[zi].setRGB(random(0, random(0, 255)), random(0, random(0, 255)), random(0, random(0, 255)));
      }
      LED[pi].setRGB(0, 0, 0);
    } else {
      for (int zi = 0; zi < pi; zi++) {
        LED[zi].setRGB(random(0, random(0, 255)), random(0, random(0, 255)), random(0, random(0, 255)));
        LED[Memoire_NB_LEDS - zi - 1].setRGB(random(0, random(0, 255)), random(0, random(0, 255)), random(0, random(0, 255)));
      }
      LED[pi].setRGB(0, 0, 0);
      LED[Memoire_NB_LEDS - pi - 1].setRGB(0, 0, 0);
    }
    FastLED.show();
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_NORMAL * 3));
  }
}


void FillLEDsFromPaletteColors_Portion(uint8_t colorIndex, int Depart, int Nombre) {

  for (pi = Depart; pi < Nombre; pi++) {
    LED[pi] = ColorFromPalette(currentPalette, colorIndex, Memoire_Luminosite, currentBlending);
    colorIndex += 1;
  }
}

void Vumetre_Palette_Alarme() {
  if (!DoOne) {
    Eteindre();
    Init_Palette();


    Global_i = 1;
    DoOne = true;
  }
  Init_Palette_Perm();




  static uint8_t startIndex = 0;
  startIndex = startIndex + 2;



  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage) / Memoire_Portions);

  int intervalle = (Memoire_NB_LEDS / Memoire_Portions);

  if (Vumetre_Value > 0) {
    Vumetre_Value = Vumetre_Value * Memoire_Gain;
    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      if (peak > Memoire_NB_LEDS / Memoire_Portions) peak = Memoire_NB_LEDS / Memoire_Portions;

      for (int j = 1; j <= Memoire_Portions; j++) {
        int Allumage = (intervalle * j) - intervalle;
        if (Allumage > Memoire_NB_LEDS) Allumage = Memoire_NB_LEDS;

        FillLEDsFromPaletteColors_Portion(startIndex, Allumage, Allumage + peak);
        FastLED.show();
        //FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_ALARME * 50));
      }
    }
  } else {

    pi = peak;
    pi--;
    peak--;
    if (pi < 0) pi = 0;


    int Allumage;
    for (int i = 1; i <= Memoire_Portions; i++) {
      Allumage = ((intervalle * i) - intervalle) + pi;
      if (Allumage > Memoire_NB_LEDS) Allumage = Memoire_NB_LEDS;
      /*LED[Allumage].red = 0;
      LED[Allumage].green = 0;
      LED[Allumage].blue = 0;*/
      LED[Allumage].setRGB(0, 0, 0);
    }
    FastLED.show();
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_ALARME * 50));
  }
}

void Vumetre_Palette() {

  if (!DoOne) {
    Eteindre();
    Init_Palette();
    sw = false;
    pi = 0;
    DoOne = true;
  }

  Init_Palette_Perm();



  static uint8_t startIndex = 0;
  startIndex = startIndex + 3;



  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095);

  Vumetre_Value = Vumetre_Value - Memoire_Decalage;



  if (Vumetre_Value > 0) {

    if (Memoire_Sym == 0) {
      Vumetre_Value = Vumetre_Value * Memoire_Gain;
    } else {
      Vumetre_Value = (Vumetre_Value * Memoire_Gain) / 2;
    }



    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      if (peak > Memoire_NB_LEDS) peak = Memoire_NB_LEDS;




      if (Memoire_Mode == "Respiration") {
        FillLEDsFromPaletteColors_Nb_Respiration(startIndex, peak);
      } else {
        FillLEDsFromPaletteColors_Nb(startIndex, peak);
      }

      FastLED.show();
    }
  } else {

    if (Vu_Supp) pi -= 3;
    else pi--;

    if (pi < 0) pi = 0;
    peak = pi;

    if (Memoire_Mode != "Respiration") {
      if (Vu_Supp) {
        if (Memoire_Sym == 0) {
          if (pi + 2 < Memoire_NB_LEDS) LED[pi + 2].setRGB(0, 0, 0);
          if (pi + 1 < Memoire_NB_LEDS) LED[pi + 1].setRGB(0, 0, 0);
          LED[pi].setRGB(0, 0, 0);
        } else {
          LED[pi + 2].setRGB(0, 0, 0);
          LED[pi + 1].setRGB(0, 0, 0);
          LED[pi].setRGB(0, 0, 0);
          LED[Memoire_NB_LEDS - pi - 1].setRGB(0, 0, 0);
          LED[Memoire_NB_LEDS - pi - 1 - 1].setRGB(0, 0, 0);
          LED[Memoire_NB_LEDS - pi - 1 - 2].setRGB(0, 0, 0);
        }



      } else {
        if (Memoire_Sym == 0) {
          LED[pi].setRGB(0, 0, 0);
        } else {
          LED[pi].setRGB(0, 0, 0);
          LED[Memoire_NB_LEDS - pi - 1].setRGB(0, 0, 0);
        }
      }
    }

    if (Memoire_Mode == "Respiration") {
      fadeToBlackBy(LED, Memoire_NB_LEDS, 20);
      blur1d(LED, Memoire_NB_LEDS, 172);

      FastLED.show();
      FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_NORMAL * 4));
    } else {
      FillLEDsFromPaletteColors_Nb(startIndex, peak);
      FastLED.show();
      FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_NORMAL * 4));
    }
  }
}


void Vumetre_Palette_Pluie() {

  if (!DoOne) {
    Eteindre();
    Init_Palette();
    sw = false;
    DoOne = true;
  }

  Init_Palette_Perm();



  static uint8_t startIndex = 0;
  startIndex = startIndex + 2;



  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;



  if (Vumetre_Value > 0) {


    if (Memoire_Sym == 0) {
      Vumetre_Value = Vumetre_Value * Memoire_Gain;
    } else {
      Vumetre_Value = (Vumetre_Value * Memoire_Gain) / 2;
    }



    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      peak = peak - random(0, peak / 4);
      if (peak > Memoire_NB_LEDS) peak = Memoire_NB_LEDS;



      if (Vu_Supp) {
        if (peak + 1 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, peak + 1);
        if (peak + 2 < Memoire_NB_LEDS) FillLEDsFromPaletteColors_Num(startIndex, peak + 2);
        if (peak - 1 > 0) FillLEDsFromPaletteColors_Num(startIndex, peak - 1);
        if (peak - 2 > 0) FillLEDsFromPaletteColors_Num(startIndex, peak - 2);
        FillLEDsFromPaletteColors_Num(startIndex, peak);

      } else {
        FillLEDsFromPaletteColors_Num(startIndex, peak);
      }




      FastLED.show();
      FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_NORMAL * 3));
    }
  } else {




    pi--;
    if (pi < 0) pi = 0;
    peak = pi;
    /*LED[pi].red = 0;
    LED[pi].green = 0;
    LED[pi].blue = 0;*/
    fadeToBlackBy(LED, Memoire_NB_LEDS, 1);
    blur1d(LED, Memoire_NB_LEDS, 172);
    FastLED.show();
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_NORMAL * 3));
  }
}



void Vumetre_Palette_Ring() {


  if (!DoOne) {
    Eteindre();
    Init_Palette();
    pi = 0;
    DoOne = true;
  }

  Init_Palette_Perm();



  static uint8_t startIndex = 0;
  startIndex = startIndex + 2;



  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;

  if (Vumetre_Value > 0) {
    if (Memoire_Sym == 0) {
      Vumetre_Value = Vumetre_Value * Memoire_Gain;
    } else {
      Vumetre_Value = (Vumetre_Value * Memoire_Gain) / 2;
    }

    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      if (peak > Memoire_NB_LEDS) peak = Memoire_NB_LEDS;


      Up_Vu_Ring = true;
    }
  }

  if (Up_Vu_Ring) {
    FillLEDsFromPaletteColors_Ring_Up(startIndex, peak);
    FastLED.show();

  } else {




    pi--;

    if (pi < 0) pi = 0;
    peak = pi;


    FillLEDsFromPaletteColors_Ring_Down(startIndex, peak, 3);
  }
}


void Vumetre_Palette_Fixe() {


  if (!DoOne) {
    Eteindre();
    Init_Palette();
    DoOne = true;
  }

  Init_Palette_Perm();







  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;


  if (Vumetre_Value > 0) {


    if (Memoire_Sym == 0) {
      Vumetre_Value = Vumetre_Value * Memoire_Gain;
    } else {
      Vumetre_Value = (Vumetre_Value * Memoire_Gain) / 2;
    }

    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      if (peak > Memoire_NB_LEDS) peak = Memoire_NB_LEDS;



      FillLEDsFromPaletteColors_Nb(0, peak);
      FastLED.show();
    }
  } else {

    if (Vu_Supp) pi -= 3;
    else pi--;

    if (pi < 0) pi = 0;
    peak = pi;

    if (Memoire_Sym == 0) {
      if (Vu_Supp) {
        LED[pi + 2].setRGB(0, 0, 0);
        LED[pi + 1].setRGB(0, 0, 0);
        LED[pi].setRGB(0, 0, 0);

      } else {
        LED[pi].setRGB(0, 0, 0);
      }
    } else {
      if (Vu_Supp) {
        LED[pi + 2].setRGB(0, 0, 0);
        LED[pi + 1].setRGB(0, 0, 0);
        LED[pi].setRGB(0, 0, 0);
        LED[Memoire_NB_LEDS - pi - 1 - 2].setRGB(0, 0, 0);
        LED[Memoire_NB_LEDS - pi - 1 - 1].setRGB(0, 0, 0);
        LED[Memoire_NB_LEDS - pi - 1].setRGB(0, 0, 0);

      } else {
        LED[pi].setRGB(0, 0, 0);
        LED[Memoire_NB_LEDS - pi - 1].setRGB(0, 0, 0);
      }
    }


    FillLEDsFromPaletteColors_Nb(0, peak);
    FastLED.show();
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_NORMAL * 3));
  }
}


void Vumetre_Palette_Swipe() {
  if (!DoOne) {
    peak = 0;
    pi = 0;

    Eteindre();
    Init_Palette();

    DoOne = true;
  }

  Init_Palette_Perm();




  static uint8_t startIndex = 0;
  startIndex = startIndex + 2;



  Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
  Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095) - Memoire_Decalage;


  if (Vumetre_Value > 0) {


    Vumetre_Value = (Vumetre_Value * Memoire_Gain) / 2;

    if (Vumetre_Value > peak) {
      peak = Vumetre_Value;
      if (peak > Memoire_NB_LEDS / 2) peak = Memoire_NB_LEDS / 2;



      FillLEDsFromPaletteColors_Nb_Swipe(startIndex, peak);
      FastLED.show();
    }
  } else {

    pi--;

    if (pi < 0) pi = 0;
    peak = pi;

    LED[Memoire_NB_LEDS / 2 - pi].setRGB(0, 0, 0);
    LED[Memoire_NB_LEDS / 2 + pi].setRGB(0, 0, 0);
    LED[0].setRGB(0, 0, 0);
    LED[Memoire_NB_LEDS - 1].setRGB(0, 0, 0);



    FillLEDsFromPaletteColors_Nb_Swipe(startIndex, peak);
    FastLED.show();
    FastLED.delay(Memoire_Vitesse / (COEFF_DELAY_SWIPE * 5));
  }
}
