

void Setup_server() {
  if (RGB_DEBUG) Serial.println("------Lampe RGB------");
  Serveur.Debug(true);
  if (!SCAN_NETWORK) Serveur.Scan_Network(false);
  //Serveur.SetUser("eeBud");

  Serveur.Init();
  Serveur.SetupModule("Module RGB - WS2812B", "LEDS");
  /*Serveur.AddListModule("type", "eebsm_rgb_strip");
  Serveur.CreateListModule();*/


  Serveur.AddListParam("Mode simple", "0", false, true);
  Serveur.AddListParam("Relais", "0", false, true);
  Serveur.AddListParam("PAJ7620U2", "0", false, true);
  Serveur.AddListParam("Télécommande", "0", false, true);
  Serveur.AddListParam("Micro", "0", false, true);
  Serveur.CreateListParam();
  Serial.println("Creation");
  SIMPLE = Serveur.GetParamBool("Mode simple");
  RELAIS = Serveur.GetParamBool("Relais");
  PAJ = Serveur.GetParamBool("PAJ7620U2");
  TELECOMMANDE = Serveur.GetParamBool("Télécommande");
  MICRO = Serveur.GetParamBool("Micro");


  //Paramètres
  //SPIFFS Cachés

  Serveur.AddListParam("Nombre de leds", "10", true);
  Serveur.AddListParam("Memoire_Sym", "0", true);
  Serveur.AddListParam("Mémoire Lumière", "Off", true);
  Serveur.AddListParam("Mémoire Mode", "Normal", true);
  if (RELAIS) Serveur.AddListParam("Mémoire USB", "0", true);
  if (MICRO) Serveur.AddListParam("Mémoire Vumètre", "0", true);
  Serveur.AddListParam("Mémoire Luminosité", "200", true);
  Serveur.AddListParam("Mémoire Vitesse", "60", true);
  Serveur.AddListParam("Mémoire Portions", "4", true);
  Serveur.AddListParam("Mémoire R1", "210", true);
  Serveur.AddListParam("Mémoire G1", "0", true);
  Serveur.AddListParam("Mémoire B1", "255", true);
  Serveur.AddListParam("Mémoire R2", "0", true);
  Serveur.AddListParam("Mémoire G2", "180", true);
  Serveur.AddListParam("Mémoire B2", "255", true);
  Serveur.AddListParam("Mémoire R3", "255", true);
  Serveur.AddListParam("Mémoire G3", "180", true);
  Serveur.AddListParam("Mémoire B3", "75", true);
  if (MICRO) Serveur.AddListParam("Mémoire Gain", "8", true);
  if (MICRO) Serveur.AddListParam("Mémoire Décalage", "0", true);
  Serveur.AddListParam("Mémoire Souffle 1", "75", true);
  Serveur.AddListParam("Mémoire Souffle 2", "70", true);
  Serveur.AddListParam("Mémoire Etincelle 1", "50", true);
  Serveur.AddListParam("Mémoire Etincelle 2", "60", true);

  Serveur.AddListParam("NB_LEDS_Perso_1", "10", true);
  Serveur.AddListParam("Vumetre_Perso_1", "0", true);
  Serveur.AddListParam("Lumiere_Perso_1", "Rainbow", true);
  Serveur.AddListParam("Mode_Perso_1", "Normal", true);
  Serveur.AddListParam("Luminosite_Perso_1", "200", true);
  Serveur.AddListParam("Vitesse_Perso_1", "30", true);
  Serveur.AddListParam("Portions_Perso_1", "4", true);
  Serveur.AddListParam("Gain_Perso_1", "8", true);
  Serveur.AddListParam("Decalage_Perso_1", "45", true);
  Serveur.AddListParam("Sym_Perso_1", "0", true);
  Serveur.AddListParam("Souffle_Perso_1", "70", true);
  Serveur.AddListParam("Etincelles_Perso_1", "70", true);
  Serveur.AddListParam("R1_Perso_1", "210", true);
  Serveur.AddListParam("G1_Perso_1", "0", true);
  Serveur.AddListParam("B1_Perso_1", "255", true);
  Serveur.AddListParam("R2_Perso_1", "0", true);
  Serveur.AddListParam("G2_Perso_1", "180", true);
  Serveur.AddListParam("B2_Perso_1", "255", true);
  Serveur.AddListParam("R3_Perso_1", "255", true);
  Serveur.AddListParam("G3_Perso_1", "180", true);
  Serveur.AddListParam("B3_Perso_1", "75", true);

  Serveur.AddListParam("NB_LEDS_Perso_2", "10", true);
  Serveur.AddListParam("Vumetre_Perso_2", "0", true);
  Serveur.AddListParam("Lumiere_Perso_2", "Coeur", true);
  Serveur.AddListParam("Mode_Perso_2", "Ring", true);
  Serveur.AddListParam("Luminosite_Perso_2", "100", true);
  Serveur.AddListParam("Vitesse_Perso_2", "10", true);
  Serveur.AddListParam("Portions_Perso_2", "4", true);
  Serveur.AddListParam("Gain_Perso_2", "8", true);
  Serveur.AddListParam("Decalage_Perso_2", "45", true);
  Serveur.AddListParam("Sym_Perso_2", "1", true);
  Serveur.AddListParam("Souffle_Perso_2", "70", true);
  Serveur.AddListParam("Etincelles_Perso_2", "70", true);
  Serveur.AddListParam("R1_Perso_2", "210", true);
  Serveur.AddListParam("G1_Perso_2", "0", true);
  Serveur.AddListParam("B1_Perso_2", "255", true);
  Serveur.AddListParam("R2_Perso_2", "0", true);
  Serveur.AddListParam("G2_Perso_2", "180", true);
  Serveur.AddListParam("B2_Perso_2", "255", true);
  Serveur.AddListParam("R3_Perso_2", "255", true);
  Serveur.AddListParam("G3_Perso_2", "180", true);
  Serveur.AddListParam("B3_Perso_2", "75", true);

  Serveur.AddListParam("NB_LEDS_Perso_3", "10", true);
  Serveur.AddListParam("Vumetre_Perso_3", "1", true);
  Serveur.AddListParam("Lumiere_Perso_3", "eeBud", true);
  Serveur.AddListParam("Mode_Perso_3", "Stroboscope", true);
  Serveur.AddListParam("Luminosite_Perso_3", "200", true);
  Serveur.AddListParam("Vitesse_Perso_3", "20", true);
  Serveur.AddListParam("Portions_Perso_3", "4", true);
  Serveur.AddListParam("Gain_Perso_3", "8", true);
  Serveur.AddListParam("Decalage_Perso_3", "45", true);
  Serveur.AddListParam("Sym_Perso_3", "0", true);
  Serveur.AddListParam("Souffle_Perso_3", "70", true);
  Serveur.AddListParam("Etincelles_Perso_3", "70", true);
  Serveur.AddListParam("R1_Perso_3", "210", true);
  Serveur.AddListParam("G1_Perso_3", "0", true);
  Serveur.AddListParam("B1_Perso_3", "255", true);
  Serveur.AddListParam("R2_Perso_3", "0", true);
  Serveur.AddListParam("G2_Perso_3", "180", true);
  Serveur.AddListParam("B2_Perso_3", "255", true);
  Serveur.AddListParam("R3_Perso_3", "255", true);
  Serveur.AddListParam("G3_Perso_3", "180", true);
  Serveur.AddListParam("B3_Perso_3", "75", true);

  Serveur.AddListParam("NB_LEDS_Perso_4", "10", true);
  Serveur.AddListParam("Vumetre_Perso_4", "0", true);
  Serveur.AddListParam("Lumiere_Perso_4", "Nuages", true);
  Serveur.AddListParam("Mode_Perso_4", "Feu", true);
  Serveur.AddListParam("Luminosite_Perso_4", "255", true);
  Serveur.AddListParam("Vitesse_Perso_4", "30", true);
  Serveur.AddListParam("Portions_Perso_4", "4", true);
  Serveur.AddListParam("Gain_Perso_4", "8", true);
  Serveur.AddListParam("Decalage_Perso_4", "45", true);
  Serveur.AddListParam("Sym_Perso_4", "1", true);
  Serveur.AddListParam("Souffle_Perso_4", "70", true);
  Serveur.AddListParam("Etincelles_Perso_4", "70", true);
  Serveur.AddListParam("R1_Perso_4", "210", true);
  Serveur.AddListParam("G1_Perso_4", "0", true);
  Serveur.AddListParam("B1_Perso_4", "255", true);
  Serveur.AddListParam("R2_Perso_4", "0", true);
  Serveur.AddListParam("G2_Perso_4", "180", true);
  Serveur.AddListParam("B2_Perso_4", "255", true);
  Serveur.AddListParam("R3_Perso_4", "255", true);
  Serveur.AddListParam("G3_Perso_4", "180", true);
  Serveur.AddListParam("B3_Perso_4", "75", true);

  Serveur.AddListParam("NB_LEDS_Perso_5", "10", true);
  Serveur.AddListParam("Vumetre_Perso_5", "0", true);
  Serveur.AddListParam("Lumiere_Perso_5", "Rainbow", true);
  Serveur.AddListParam("Mode_Perso_5", "Pluie", true);
  Serveur.AddListParam("Luminosite_Perso_5", "150", true);
  Serveur.AddListParam("Vitesse_Perso_5", "20", true);
  Serveur.AddListParam("Portions_Perso_5", "4", true);
  Serveur.AddListParam("Gain_Perso_5", "8", true);
  Serveur.AddListParam("Decalage_Perso_5", "45", true);
  Serveur.AddListParam("Sym_Perso_5", "0", true);
  Serveur.AddListParam("Souffle_Perso_5", "70", true);
  Serveur.AddListParam("Etincelles_Perso_5", "70", true);
  Serveur.AddListParam("R1_Perso_5", "210", true);
  Serveur.AddListParam("G1_Perso_5", "0", true);
  Serveur.AddListParam("B1_Perso_5", "255", true);
  Serveur.AddListParam("R2_Perso_5", "0", true);
  Serveur.AddListParam("G2_Perso_5", "180", true);
  Serveur.AddListParam("B2_Perso_5", "255", true);
  Serveur.AddListParam("R3_Perso_5", "255", true);
  Serveur.AddListParam("G3_Perso_5", "180", true);
  Serveur.AddListParam("B3_Perso_5", "75", true);

  //SPIFFS Visibles

  Serveur.AddListParam("URL d'envoi de l'état de l'USB", "");
  Serveur.AddListParam("URL d'envoi du mode lumineux", "");
  Serveur.AddListParam("URL d'envoi de la palette de couleurs", "");
  Serveur.AddListParam("URL d'envoi de la luminosité des leds", "");
  Serveur.AddListParam("URL d'envoi de la vitesse des leds", "");
  Serveur.AddListParam("URL d'envoi de l'état du vu-mètre", "");
  Serveur.AddListParam("URL d'envoi du timer des leds", "");
  Serveur.AddListParam("URL d'envoi du timer de l'USB", "");

  Serveur.CreateListParam();


  //Serveur.Jeedom(true);
  Serveur.JeedomAutoRefresh(false);

  URL_Rechargement = Serveur.GetParamText("URL d'envoi de l'état de l'USB");
  URL_Lumiere_Mode = Serveur.GetParamText("URL d'envoi du mode lumineux");
  URL_Lumiere_Etat = Serveur.GetParamText("URL d'envoi de la palette de couleurs");
  URL_Lumiere_Luminosite = Serveur.GetParamText("URL d'envoi de la luminosité des leds");
  URL_Lumiere_Vitesse = Serveur.GetParamText("URL d'envoi de la vitesse des leds");
  URL_Lumiere_Vumetre = Serveur.GetParamText("URL d'envoi de l'état du vu-mètre");
  URL_Lumiere_Timer = Serveur.GetParamText("URL d'envoi du timer des leds");
  URL_Timer_USB = Serveur.GetParamText("URL d'envoi du timer de l'USB");


  Memoire_NB_LEDS = (Serveur.GetParamText("Nombre de leds")).toInt();
  Memoire_Sym = Serveur.GetParamText("Memoire_Sym").toInt();
  Memoire_Lumiere = Serveur.GetParamText("Mémoire Lumière");
  Memoire_Mode = Serveur.GetParamText("Mémoire Mode");
  if (RELAIS) Memoire_USB = (Serveur.GetParamText("Mémoire USB")).toInt();
  if (MICRO) Memoire_Vumetre = (Serveur.GetParamText("Mémoire Vumètre")).toInt();
  Memoire_Luminosite = (Serveur.GetParamText("Mémoire Luminosité")).toInt();
  Memoire_Vitesse = 100-(Serveur.GetParamText("Mémoire Vitesse")).toInt();
  Memoire_Portions = (Serveur.GetParamText("Mémoire Portions")).toInt();
  Memoire_R1 = (Serveur.GetParamText("Mémoire R1")).toInt();
  Memoire_G1 = (Serveur.GetParamText("Mémoire G1")).toInt();
  Memoire_B1 = (Serveur.GetParamText("Mémoire B1")).toInt();
  Memoire_R2 = (Serveur.GetParamText("Mémoire R2")).toInt();
  Memoire_G2 = (Serveur.GetParamText("Mémoire G2")).toInt();
  Memoire_B2 = (Serveur.GetParamText("Mémoire B2")).toInt();
  Memoire_R3 = (Serveur.GetParamText("Mémoire R3")).toInt();
  Memoire_G3 = (Serveur.GetParamText("Mémoire G3")).toInt();
  Memoire_B3 = (Serveur.GetParamText("Mémoire B3")).toInt();
  if (MICRO) Memoire_Gain = (Serveur.GetParamText("Mémoire Gain")).toInt();
  if (MICRO) Memoire_Decalage = (Serveur.GetParamText("Mémoire Décalage")).toInt();

  if (Memoire_Decalage == 0) {
    int mesure_max = 0;
    for (int i = 0; i < 500; i++) {
      Vumetre_Value = (analogRead(MICRO_PIN) * -1) + 4095;
      Vumetre_Value = ((Vumetre_Value * Memoire_NB_LEDS) / 4095);
      if (mesure_max < Vumetre_Value) mesure_max = Vumetre_Value;
    }
    Memoire_Decalage = mesure_max + 1;
  }

  Memoire_Souffle_1 = (Serveur.GetParamText("Mémoire Souffle 1")).toInt();
  Memoire_Souffle_2 = (Serveur.GetParamText("Mémoire Souffle 2")).toInt();
  Memoire_Etincelles_1 = (Serveur.GetParamText("Mémoire Etincelle 1")).toInt();
  Memoire_Etincelles_2 = (Serveur.GetParamText("Mémoire Etincelle 2")).toInt();


  gNB_LEDS_Perso_1 = Serveur.GetParamText("NB_LEDS_Perso_1").toInt();
  gMode_Perso_1 = Serveur.GetParamText("Mode_Perso_1");
  gLumiere_Perso_1 = Serveur.GetParamText("Lumiere_Perso_1");
  gVumetre_Perso_1 = Serveur.GetParamText("Vumetre_Perso_1").toInt();
  gLuminosite_Perso_1 = Serveur.GetParamText("Luminosite_Perso_1").toInt();
  gVitesse_Perso_1 = 100-Serveur.GetParamText("Vitesse_Perso_1").toInt();
  gPortions_Perso_1 = Serveur.GetParamText("Portions_Perso_1").toInt();
  gGain_Perso_1 = Serveur.GetParamText("Gain_Perso_1").toInt();
  gDecalage_Perso_1 = Serveur.GetParamText("Decalage_Perso_1").toInt();
  gSym_Perso_1 = Serveur.GetParamText("Sym_Perso_1").toInt();
  gSouffle_Perso_1 = Serveur.GetParamText("Souffle_Perso_1").toInt();
  gEtincelles_Perso_1 = Serveur.GetParamText("Etincelles_Perso_1").toInt();
  gR1_Perso_1 = Serveur.GetParamText("R1_Perso_1").toInt();
  gG1_Perso_1 = Serveur.GetParamText("G1_Perso_1").toInt();
  gB1_Perso_1 = Serveur.GetParamText("B1_Perso_1").toInt();
  gR2_Perso_1 = Serveur.GetParamText("R2_Perso_1").toInt();
  gG2_Perso_1 = Serveur.GetParamText("G2_Perso_1").toInt();
  gB2_Perso_1 = Serveur.GetParamText("B2_Perso_1").toInt();
  gR3_Perso_1 = Serveur.GetParamText("R3_Perso_1").toInt();
  gG3_Perso_1 = Serveur.GetParamText("G3_Perso_1").toInt();
  gB3_Perso_1 = Serveur.GetParamText("B3_Perso_1").toInt();
  
  gNB_LEDS_Perso_2 = Serveur.GetParamText("NB_LEDS_Perso_2").toInt();
  gMode_Perso_2 = Serveur.GetParamText("Mode_Perso_2");
  gLumiere_Perso_2 = Serveur.GetParamText("Lumiere_Perso_2");
  gVumetre_Perso_2 = Serveur.GetParamText("Vumetre_Perso_2").toInt();
  gLuminosite_Perso_2 = Serveur.GetParamText("Luminosite_Perso_2").toInt();
  gVitesse_Perso_2 = 100-Serveur.GetParamText("Vitesse_Perso_2").toInt();
  gPortions_Perso_2 = Serveur.GetParamText("Portions_Perso_2").toInt();
  gGain_Perso_2 = Serveur.GetParamText("Gain_Perso_2").toInt();
  gDecalage_Perso_2 = Serveur.GetParamText("Decalage_Perso_2").toInt();
  gSym_Perso_2 = Serveur.GetParamText("Sym_Perso_2").toInt();
  gSouffle_Perso_2 = Serveur.GetParamText("Souffle_Perso_2").toInt();
  gEtincelles_Perso_2 = Serveur.GetParamText("Etincelles_Perso_2").toInt();
  gR1_Perso_2 = Serveur.GetParamText("R1_Perso_2").toInt();
  gG1_Perso_2 = Serveur.GetParamText("G1_Perso_2").toInt();
  gB1_Perso_2 = Serveur.GetParamText("B1_Perso_2").toInt();
  gR2_Perso_2 = Serveur.GetParamText("R2_Perso_2").toInt();
  gG2_Perso_2 = Serveur.GetParamText("G2_Perso_2").toInt();
  gB2_Perso_2 = Serveur.GetParamText("B2_Perso_2").toInt();
  gR3_Perso_2 = Serveur.GetParamText("R3_Perso_2").toInt();
  gG3_Perso_2 = Serveur.GetParamText("G3_Perso_2").toInt();
  gB3_Perso_2 = Serveur.GetParamText("B3_Perso_2").toInt();
  
  gNB_LEDS_Perso_3 = Serveur.GetParamText("NB_LEDS_Perso_3").toInt();
  gMode_Perso_3 = Serveur.GetParamText("Mode_Perso_3");
  gLumiere_Perso_3 = Serveur.GetParamText("Lumiere_Perso_3");
  gVumetre_Perso_3 = Serveur.GetParamText("Vumetre_Perso_3").toInt();
  gLuminosite_Perso_3 = Serveur.GetParamText("Luminosite_Perso_3").toInt();
  gVitesse_Perso_3 = 100-Serveur.GetParamText("Vitesse_Perso_3").toInt();
  gPortions_Perso_3 = Serveur.GetParamText("Portions_Perso_3").toInt();
  gGain_Perso_3 = Serveur.GetParamText("Gain_Perso_3").toInt();
  gDecalage_Perso_3 = Serveur.GetParamText("Decalage_Perso_3").toInt();
  gSym_Perso_3 = Serveur.GetParamText("Sym_Perso_3").toInt();
  gSouffle_Perso_3 = Serveur.GetParamText("Souffle_Perso_3").toInt();
  gEtincelles_Perso_3 = Serveur.GetParamText("Etincelles_Perso_3").toInt();
  gR1_Perso_3 = Serveur.GetParamText("R1_Perso_3").toInt();
  gG1_Perso_3 = Serveur.GetParamText("G1_Perso_3").toInt();
  gB1_Perso_3 = Serveur.GetParamText("B1_Perso_3").toInt();
  gR2_Perso_3 = Serveur.GetParamText("R2_Perso_3").toInt();
  gG2_Perso_3 = Serveur.GetParamText("G2_Perso_3").toInt();
  gB2_Perso_3 = Serveur.GetParamText("B2_Perso_3").toInt();
  gR3_Perso_3 = Serveur.GetParamText("R3_Perso_3").toInt();
  gG3_Perso_3 = Serveur.GetParamText("G3_Perso_3").toInt();
  gB3_Perso_3 = Serveur.GetParamText("B3_Perso_3").toInt();
  
  gNB_LEDS_Perso_4 = Serveur.GetParamText("NB_LEDS_Perso_4").toInt();
  gMode_Perso_4 = Serveur.GetParamText("Mode_Perso_4");
  gLumiere_Perso_4 = Serveur.GetParamText("Lumiere_Perso_4");
  gVumetre_Perso_4 = Serveur.GetParamText("Vumetre_Perso_4").toInt();
  gLuminosite_Perso_4 = Serveur.GetParamText("Luminosite_Perso_4").toInt();
  gVitesse_Perso_4 = 100-Serveur.GetParamText("Vitesse_Perso_4").toInt();
  gPortions_Perso_4 = Serveur.GetParamText("Portions_Perso_4").toInt();
  gGain_Perso_4 = Serveur.GetParamText("Gain_Perso_4").toInt();
  gDecalage_Perso_4 = Serveur.GetParamText("Decalage_Perso_4").toInt();
  gSym_Perso_4 = Serveur.GetParamText("Sym_Perso_4").toInt();
  gSouffle_Perso_4 = Serveur.GetParamText("Souffle_Perso_4").toInt();
  gEtincelles_Perso_4 = Serveur.GetParamText("Etincelles_Perso_4").toInt();
  gR1_Perso_4 = Serveur.GetParamText("R1_Perso_4").toInt();
  gG1_Perso_4 = Serveur.GetParamText("G1_Perso_4").toInt();
  gB1_Perso_4 = Serveur.GetParamText("B1_Perso_4").toInt();
  gR2_Perso_4 = Serveur.GetParamText("R2_Perso_4").toInt();
  gG2_Perso_4 = Serveur.GetParamText("G2_Perso_4").toInt();
  gB2_Perso_4 = Serveur.GetParamText("B2_Perso_4").toInt();
  gR3_Perso_4 = Serveur.GetParamText("R3_Perso_4").toInt();
  gG3_Perso_4 = Serveur.GetParamText("G3_Perso_4").toInt();
  gB3_Perso_4 = Serveur.GetParamText("B3_Perso_4").toInt();
  
  gNB_LEDS_Perso_5 = Serveur.GetParamText("NB_LEDS_Perso_5").toInt();
  gMode_Perso_5 = Serveur.GetParamText("Mode_Perso_5");
  gLumiere_Perso_5 = Serveur.GetParamText("Lumiere_Perso_5");
  gVumetre_Perso_5 = Serveur.GetParamText("Vumetre_Perso_5").toInt();
  gLuminosite_Perso_5 = Serveur.GetParamText("Luminosite_Perso_5").toInt();
  gVitesse_Perso_5 = 100-Serveur.GetParamText("Vitesse_Perso_5").toInt();
  gPortions_Perso_5 = Serveur.GetParamText("Portions_Perso_5").toInt();
  gGain_Perso_5 = Serveur.GetParamText("Gain_Perso_5").toInt();
  gDecalage_Perso_5 = Serveur.GetParamText("Decalage_Perso_5").toInt();
  gSym_Perso_5 = Serveur.GetParamText("Sym_Perso_5").toInt();
  gSouffle_Perso_5 = Serveur.GetParamText("Souffle_Perso_5").toInt();
  gEtincelles_Perso_5 = Serveur.GetParamText("Etincelles_Perso_5").toInt();
  gR1_Perso_5 = Serveur.GetParamText("R1_Perso_5").toInt();
  gG1_Perso_5 = Serveur.GetParamText("G1_Perso_5").toInt();
  gB1_Perso_5 = Serveur.GetParamText("B1_Perso_5").toInt();
  gR2_Perso_5 = Serveur.GetParamText("R2_Perso_5").toInt();
  gG2_Perso_5 = Serveur.GetParamText("G2_Perso_5").toInt();
  gB2_Perso_5 = Serveur.GetParamText("B2_Perso_5").toInt();
  gR3_Perso_5 = Serveur.GetParamText("R3_Perso_5").toInt();
  gG3_Perso_5 = Serveur.GetParamText("G3_Perso_5").toInt();
  gB3_Perso_5 = Serveur.GetParamText("B3_Perso_5").toInt();
  



  ///////////////Mise en page de l'index///////////////
  Serveur.IndexAddLittleLogo("https://www.eedock.fr/eedock/img/eeBud.png", 100, 100);
  Serveur.IndexBottomText("<a style=\"text-decoration:none; color: var(--text-color);\" href=\"https://eebud.fr\" target=\"_blank\">Visitez eeBud.fr !</a>");

  //////////////////////////////


  int *Bouton;

  if (!SIMPLE) {

    Serveur.IndexTableStart();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Colonne de gauche
    Serveur.IndexTableStart();


    //Infos






    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 2

    //Modes lumineux
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Leds", "60");
    Bouton = Serveur.IndexAddToogle("Allumer", "Off", "On", "Off");
    Bouton_Allumer_Off = Bouton[0];
    Bouton_Allumer_On = Bouton[1];

    Range_Timer = Serveur.IndexAddRange("Minuterie des leds (min)", 0, 300, 0);
    Serveur.IndexSetRange(Range_Timer, Memoire_Timer);
    Bouton = Serveur.IndexAddToogle("Symétrie");
    Bouton_Sym_Off = Bouton[0];
    Bouton_Sym_On = Bouton[1];
    Item_Lumiere_Null = Serveur.IndexAddList("Palettes de couleurs", "");
    Item_Lumiere_Off = Serveur.IndexAddList("Palettes de couleurs", "Off");
    Item_Lumiere_BC = Serveur.IndexAddList("Palettes de couleurs", "Blanc chaud");
    Item_Lumiere_BF = Serveur.IndexAddList("Palettes de couleurs", "Blanc froid");
    Item_Lumiere_Rainbow = Serveur.IndexAddList("Palettes de couleurs", "Rainbow");
    Item_Lumiere_Rainbow_Stripe = Serveur.IndexAddList("Palettes de couleurs", "Rainbow stripe");
    Item_Lumiere_Nuages = Serveur.IndexAddList("Palettes de couleurs", "Nuages");
    Item_Lumiere_Ocean = Serveur.IndexAddList("Palettes de couleurs", "Océan");
    Item_Lumiere_Foret = Serveur.IndexAddList("Palettes de couleurs", "Forêt");
    Item_Lumiere_Lave = Serveur.IndexAddList("Palettes de couleurs", "Lave");
    Item_Lumiere_Fete = Serveur.IndexAddList("Palettes de couleurs", "Fête");
    Item_Lumiere_Coeur = Serveur.IndexAddList("Palettes de couleurs", "Coeur");
    Item_Lumiere_eeBud = Serveur.IndexAddList("Palettes de couleurs", "eeBud");
    Item_Lumiere_Confetis = Serveur.IndexAddList("Palettes de couleurs", "Confétis");
    Item_Lumiere_Random = Serveur.IndexAddList("Palettes de couleurs", "Random");
    Item_Lumiere_Perso = Serveur.IndexAddList("Palettes de couleurs", "Perso");
    Item_Preset_Null = Serveur.IndexAddList("Mode", "");
    Item_Preset_Normal = Serveur.IndexAddList("Mode", "Normal");
    Item_Preset_Fixe = Serveur.IndexAddList("Mode", "Fixe");
    Item_Preset_Feu_1 = Serveur.IndexAddList("Mode", "Feu");
    Item_Preset_Swipe = Serveur.IndexAddList("Mode", "Swipe");
    Item_Preset_Ring = Serveur.IndexAddList("Mode", "Ring");
    Item_Preset_Alarm = Serveur.IndexAddList("Mode", "Alarme");
    Item_Preset_Pluie = Serveur.IndexAddList("Mode", "Pluie");
    Item_Preset_Respiration = Serveur.IndexAddList("Mode", "Respiration");
    Item_Preset_Strob = Serveur.IndexAddList("Mode", "Stroboscope");
    Couleur_1 = Serveur.IndexAddColor("Couleur 1", 210, 0, 255);
    Couleur_2 = Serveur.IndexAddColor("Couleur 2", 0, 180, 255);
    Couleur_3 = Serveur.IndexAddColor("Couleur 3", 0, 180, 255);
    Serveur.IndexSetColor(Couleur_1, Memoire_R1, Memoire_G1, Memoire_B1);
    Serveur.IndexSetColor(Couleur_2, Memoire_R2, Memoire_G2, Memoire_B2);
    Serveur.IndexSetColor(Couleur_3, Memoire_R3, Memoire_G3, Memoire_B3);
    Bouton_Palette_Random = Serveur.IndexAddButton("Changer les couleurs");
    Serveur.IndexTileFinish();

    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 3

    //Modes persos
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Combinaisons persos", "60");
    Bouton_Combinaison_Perso_1 = Serveur.IndexAddButton("Combinaison perso 1", false);
    Bouton_Combinaison_Perso_Save_1 = Serveur.IndexAddTooltip("!", "Enregistrer la combinaison perso 1");
    Bouton_Combinaison_Perso_2 = Serveur.IndexAddButton("Combinaison perso 2", false);
    Bouton_Combinaison_Perso_Save_2 = Serveur.IndexAddTooltip("!", "Enregistrer la combinaison perso 2");
    Bouton_Combinaison_Perso_3 = Serveur.IndexAddButton("Combinaison perso 3", false);
    Bouton_Combinaison_Perso_Save_3 = Serveur.IndexAddTooltip("!", "Enregistrer la combinaison perso 3");
    Bouton_Combinaison_Perso_4 = Serveur.IndexAddButton("Combinaison perso 4", false);
    Bouton_Combinaison_Perso_Save_4 = Serveur.IndexAddTooltip("!", "Enregistrer la combinaison perso 4");
    Bouton_Combinaison_Perso_5 = Serveur.IndexAddButton("Combinaison perso 5", false);
    Bouton_Combinaison_Perso_Save_5 = Serveur.IndexAddTooltip("!", "Enregistrer la combinaison perso 5");
    Serveur.IndexTileFinish();



    //Colonne de droite
    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexTableFinish();
    Serveur.IndexCellFinish();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    Serveur.IndexTableStart();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 4

    //Paramètres des leds
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Paramètres des leds", "60");

    Range_NB_LEDS = Serveur.IndexAddRange("Nombre de leds", 1, 250, 0);
    Serveur.IndexSetRange(Range_NB_LEDS, Memoire_NB_LEDS);

    Range_Luminosite = Serveur.IndexAddRange("Luminosité", 0, 255, 0);
    Serveur.IndexSetRange(Range_Luminosite, Memoire_Luminosite);
    RAM_luminosite_leds = Memoire_Luminosite;
    Range_Vitesse = Serveur.IndexAddRange("Vitesse", 0, 100, 0);
    Serveur.IndexSetRange(Range_Vitesse, 100 - Memoire_Vitesse);

    Range_Portions = Serveur.IndexAddRange("Portions mode alarme", 1, 4, 0);
    Serveur.IndexSetRange(Range_Portions, Memoire_Portions);
    Range_Souffle = Serveur.IndexAddRange("Souffle mode feu", 20, 200, 0);
    Range_Etincelles = Serveur.IndexAddRange("Eteincelles mode feu", 20, 200, 0);

    if (Memoire_Sym == 0) {
      Serveur.IndexSetRange(Range_Souffle, Memoire_Souffle_1);
      Serveur.IndexSetRange(Range_Etincelles, Memoire_Etincelles_1);
    } else {
      Serveur.IndexSetRange(Range_Souffle, Memoire_Souffle_2);
      Serveur.IndexSetRange(Range_Etincelles, Memoire_Etincelles_2);
    }

    Serveur.IndexTileFinish();

    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 5

    //Vu-mètre
    if (MICRO) {
      Serveur.IndexTileStart("700px", "", "");
      Serveur.IndexAddTitle("Vu-mètre", "60");
      Bouton = Serveur.IndexAddToogle("Vu-mètre", "Off", "On", "Off");
      Bouton_Vumetre_Off = Bouton[0];
      Bouton_Vumetre_On = Bouton[1];
      Range_Gain_Vumetre = Serveur.IndexAddRange("Gain", 1, 30, 0);
      Serveur.IndexSetRange(Range_Gain_Vumetre, Memoire_Gain);

      Range_Decalage_Vumetre = Serveur.IndexAddRange("Sensibilité", 1, 200, 0);
      Serveur.IndexSetRange(Range_Decalage_Vumetre, Memoire_Decalage);

      Bouton_Etalonner = Serveur.IndexAddTooltip("!", "Réinitialise le décalage en fonction du bruit de fond.");
      Serveur.IndexTileFinish();
    }

    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 6

    //USB
    if (RELAIS) {
      Serveur.IndexTileStart("700px", "", "");
      Serveur.IndexAddTitle("USB", "60");
      Bouton = Serveur.IndexAddToogle("Prise USB", "Off", "On", "Off");
      Bouton_Rechargement_Off = Bouton[0];
      Bouton_Rechargement_On = Bouton[1];
      Range_Timer_USB = Serveur.IndexAddRange("Minuterie USB (min)", 0, 300, 0);
      Serveur.IndexSetRange(Range_Timer_USB, Memoire_Timer_USB);
      Serveur.IndexTileFinish();
    }


    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexTableFinish();


    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexTableFinish();




    //Sauvegarde
    Serveur.IndexTileStart("90%%", "", "");
    Bouton_Reinitialiser = Serveur.IndexAddTooltip("R", "Réinitialisation de la page.", false);
    Bouton_Save = Serveur.IndexAddTooltip("S", "Sauvegarde de la page pour le prochain démarrage.");
    Serveur.IndexTileFinish();




  } else {

    Serveur.IndexTableStart();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Colonne de gauche
    Serveur.IndexTableStart();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 1

    //Infos
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Général", "60");

    Bouton = Serveur.IndexAddToogle("Allumer", "Off", "On", "Off");
    Bouton_Allumer_Off = Bouton[0];
    Bouton_Allumer_On = Bouton[1];

    Serveur.IndexAddHTML("<BR>");


    Bouton = Serveur.IndexAddToogle("Musique", "Off", "On", "Off");
    Bouton_Vumetre_Off = Bouton[0];
    Bouton_Vumetre_On = Bouton[1];

    Bouton = Serveur.IndexAddToogle("Symétrie");
    Bouton_Sym_Off = Bouton[0];
    Bouton_Sym_On = Bouton[1];

    //USB
    if (RELAIS) {
      Bouton = Serveur.IndexAddToogle("Prise USB", "Off", "On", "Off");
      Bouton_Rechargement_Off = Bouton[0];
      Bouton_Rechargement_On = Bouton[1];
    }

    Serveur.IndexAddHTML("<BR>");

    Range_Timer = Serveur.IndexAddRange("Timer (min)", 0, 300, 0);
    Serveur.IndexSetRange(Range_Timer, Memoire_Timer);
    if (RELAIS) {
      Range_Timer_USB = Serveur.IndexAddRange("Timer USB (min)", 0, 300, 0);
      Serveur.IndexSetRange(Range_Timer_USB, Memoire_Timer_USB);
    }

    Serveur.IndexTileFinish();

    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 2

    //Modes lumineux
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Modes lumineux", "60");


    Item_Lumiere_Null = Serveur.IndexAddList("Palettes de couleurs", "");
    Item_Lumiere_Off = Serveur.IndexAddList("Palettes de couleurs", "Off");
    Item_Lumiere_BC = Serveur.IndexAddList("Palettes de couleurs", "Blanc chaud");
    Item_Lumiere_BF = Serveur.IndexAddList("Palettes de couleurs", "Blanc froid");
    Item_Lumiere_Rainbow = Serveur.IndexAddList("Palettes de couleurs", "Rainbow");
    Item_Lumiere_Rainbow_Stripe = Serveur.IndexAddList("Palettes de couleurs", "Rainbow stripe");
    Item_Lumiere_Nuages = Serveur.IndexAddList("Palettes de couleurs", "Nuages");
    Item_Lumiere_Ocean = Serveur.IndexAddList("Palettes de couleurs", "Océan");
    Item_Lumiere_Foret = Serveur.IndexAddList("Palettes de couleurs", "Forêt");
    Item_Lumiere_Lave = Serveur.IndexAddList("Palettes de couleurs", "Lave");
    Item_Lumiere_Fete = Serveur.IndexAddList("Palettes de couleurs", "Fête");
    Item_Lumiere_Coeur = Serveur.IndexAddList("Palettes de couleurs", "Coeur");
    Item_Lumiere_eeBud = Serveur.IndexAddList("Palettes de couleurs", "eeBud");
    Item_Lumiere_Confetis = Serveur.IndexAddList("Palettes de couleurs", "Confétis");
    Item_Lumiere_Random = Serveur.IndexAddList("Palettes de couleurs", "Random");
    Item_Lumiere_Perso = Serveur.IndexAddList("Palettes de couleurs", "Perso");
    Item_Preset_Null = Serveur.IndexAddList("Mode", "");
    Item_Preset_Normal = Serveur.IndexAddList("Mode", "Normal");
    Item_Preset_Fixe = Serveur.IndexAddList("Mode", "Fixe");
    Item_Preset_Feu_1 = Serveur.IndexAddList("Mode", "Feu");
    Item_Preset_Swipe = Serveur.IndexAddList("Mode", "Swipe");
    Item_Preset_Ring = Serveur.IndexAddList("Mode", "Ring");
    Item_Preset_Alarm = Serveur.IndexAddList("Mode", "Alarme");
    Item_Preset_Pluie = Serveur.IndexAddList("Mode", "Pluie");
    Item_Preset_Respiration = Serveur.IndexAddList("Mode", "Respiration");
    Item_Preset_Strob = Serveur.IndexAddList("Mode", "Stroboscope");
    Couleur_1 = Serveur.IndexAddColor("Couleur 1", 210, 0, 255);
    Couleur_2 = Serveur.IndexAddColor("Couleur 2", 0, 180, 255);
    Couleur_3 = Serveur.IndexAddColor("Couleur 3", 0, 180, 255);
    Serveur.IndexSetColor(Couleur_1, Memoire_R1, Memoire_G1, Memoire_B1);
    Serveur.IndexSetColor(Couleur_2, Memoire_R2, Memoire_G2, Memoire_B2);
    Serveur.IndexSetColor(Couleur_3, Memoire_R3, Memoire_G3, Memoire_B3);
    Bouton_Palette_Random = Serveur.IndexAddButton("Changer les couleurs");
    Serveur.IndexTileFinish();

    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexTableFinish();
    Serveur.IndexCellFinish();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    Serveur.IndexTableStart();
    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 4

    //Paramètres des leds
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Paramètres des leds", "60");

    Range_Luminosite = Serveur.IndexAddRange("Luminosité", 0, 255, 0);
    Serveur.IndexSetRange(Range_Luminosite, Memoire_Luminosite);
    RAM_luminosite_leds = Memoire_Luminosite;
    Range_Vitesse = Serveur.IndexAddRange("Vitesse", 0, 100, 0);
    Serveur.IndexSetRange(Range_Vitesse, 100 - Memoire_Vitesse);

    if (MICRO) {
      Serveur.IndexAddHTML("<BR>");
      Serveur.IndexAddTitle("Musique", "60");

      Range_Gain_Vumetre = Serveur.IndexAddRange("Gain", 1, 30, 0);
      Serveur.IndexSetRange(Range_Gain_Vumetre, Memoire_Gain);
      Bouton_Etalonner = Serveur.IndexAddTooltip("!", "Réinitialise le décalage en fonction du bruit de fond.");
    }

    Serveur.IndexTileFinish();

    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();

    Serveur.IndexRowStart();
    Serveur.IndexCellStart(1, 1, "", "", "", false);
    //Case 3

    //Modes persos
    Serveur.IndexTileStart("700px", "", "");
    Serveur.IndexAddTitle("Combinaisons persos", "60");
    Bouton_Combinaison_Perso_1 = Serveur.IndexAddButton("Combinaison perso 1", false);
    Bouton_Combinaison_Perso_2 = Serveur.IndexAddButton("Combinaison perso 2", false);
    Bouton_Combinaison_Perso_3 = Serveur.IndexAddButton("Combinaison perso 3", false);
    Bouton_Combinaison_Perso_4 = Serveur.IndexAddButton("Combinaison perso 4", false);
    Bouton_Combinaison_Perso_5 = Serveur.IndexAddButton("Combinaison perso 5", false);
    Serveur.IndexTileFinish();



    //Colonne de droite
    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();

    Serveur.IndexTableFinish();


    Serveur.IndexCellFinish();
    Serveur.IndexRowFinish();
    Serveur.IndexTableFinish();
  }















  ///////////////Fin de mise en page de l'index///////////////
}